//
//  SDKAutoUpgrade.h
//  AriesX
//
//  Created by mingfyan on 15/4/24.
//  Copyright (c) 2015 Cisco Systems. All rights reserved.
//

#ifndef __AriesX__SDKAutoUpgrade__
#define __AriesX__SDKAutoUpgrade__

#include <string>
#include <sstream>
#include <functional>

#include "csfunified/library/CSFUnified.h"
#include "csfunified/framework/ServicesDispatcher.h"
#include "csfunified/framework/UnifiedFactory.h"
#include "csf/Timer.hpp"
#include "csf/Event.hpp"

#include "csf/cert/CertVerifierFactory.hpp"

#include "../services/impl/NetUtilBridge.h"

#include "unzip.h"

using namespace CSFUnified;

struct MeetingSDKVersion
{
    unsigned long major;
    unsigned long middle;
    unsigned long minor;
    unsigned long build;
    
    const static char delim;
    
    MeetingSDKVersion() : major(0), middle(0), minor(0), build(0)
    {
    }
    
    std::string ToString();
    
    void FromString(std::string versionStr);
    
    bool isLargerThan(const MeetingSDKVersion& version);
    
    bool isEqualTo(const MeetingSDKVersion& version);
};

class CustomizedSyncHttpQuery
{
public:
	CustomizedSyncHttpQuery(NetUtilTransport* pNetUtilTransport)
	{
		m_pNetUtilTransport = pNetUtilTransport;
	}

	bool HttpQuery(std::string queryUrl, std::string &content)
	{
		if (NULL != m_pNetUtilTransport)
		{
			std::vector<std::string> header;
			m_pNetUtilTransport->HttpRequest(queryUrl, header, "", JM_HTTP_POST, 
				std::bind(&CustomizedSyncHttpQuery::onSuccess, this, std::placeholders::_1, std::placeholders::_2),
				std::bind(&CustomizedSyncHttpQuery::onError, this, std::placeholders::_1));

			content = m_responseContent;

			return m_success;
		}
		else
		{
			return false;
		}
	}

private:
	void onSuccess(int responseCode, const std::string& content)
	{
		if (200 == responseCode)
		{
			m_responseContent = content;
			m_success = true;
		}
		else
		{
			m_success = false;
		}
	}

	void onError(int result)
	{
		m_success = false;
	}

private:
	NetUtilTransport* m_pNetUtilTransport;

	std::string m_responseContent;
	bool m_success;
};

struct SDKUpdateQuery
{
    bool isSuccess;
    bool isUpgrade;
    std::string version;
    std::string fileUrl;
    std::string hashKey;
    
    long long currentTimeInSeconds;
    
    const static std::string SUCCESS_KEY;
    const static std::string UPGRADE_KEY;
    const static std::string VERSION_KEY;
    const static std::string FILEURL_KEY;
    const static std::string HASHKEY_KEY;
    
    static bool ParseQueryReponse(std::string text, SDKUpdateQuery& result);
};

class LocalSDKConfigs
{
public:
    const static std::string CHECKTIME_KEY;
    const static std::string TGT_VER_KEY;
    const static std::string TGT_LOCATION_KEY;
    
    static LocalSDKConfigs* getInstance()
    {
        if(!m_pInstance)
        {
            m_pInstance = new LocalSDKConfigs();
        }
        return m_pInstance;
    }
    
    long long getLastCheckTime()
    {
        return lastCheckTime;
    }
    
    std::string getTargetVersion()
    {
        return targetVer;
    }
    
    std::string getTargetLocation()
    {
        return targetLocation;
    }
    
    void updateQueryTime(long long checkTime)
    {
        lastCheckTime = checkTime;
    }
    
    void update(long long checkTime, std::string version, std::string location)
    {
        lastCheckTime = checkTime;
        targetVer = version;
        targetLocation = location;
    }
    
    bool loadFromFile(std::string configFile);
    bool dumpToFile(std::string configFile);
    
private:
    LocalSDKConfigs() : lastCheckTime(0), targetVer(""), targetLocation(""), m_configFile(""){};
    static LocalSDKConfigs* m_pInstance;
    
    long long lastCheckTime;
    std::string targetVer;
    std::string targetLocation;
    std::string m_configFile;
};

class TaskDelayTrigger : public csf::TimerCallback
{
public:
    TaskDelayTrigger(long delaySeconds, csf::TimerCallback* task, long executeInterval);
    ~TaskDelayTrigger();
    
    void onTimerFired(csf::TimerHelper *timer);
    
private:
    csf::TimerCallback* m_task;
    long m_interval;
    
    csf::TimerHelper* m_triggerTimer;
    csf::TimerHelper* m_taskTimer;
};

class IAutoUpgradeHandler
{
public:
    virtual std::string getMonitorUrl() = 0;
    virtual long long getLastCheckTime() = 0;
    virtual long getUpgradeCheckInterval() = 0;
    virtual std::string getDownloadZipPath() = 0;
    
    virtual NetUtilTransportDownloader* getNetUtilTransportDownloader() = 0;
    
    virtual void onQuery(const SDKUpdateQuery& result) = 0;
    virtual void downloadToFileComplete(NetUtilDownloadResultEnum::NetUtilDownloadResult result) = 0;
    virtual csf::Event* getDownloadCompleteEvent() = 0;
    virtual long getDownloadWaitTimeoutSeconds() = 0;
};

class AutoUpgradeTask : public csf::TimerCallback
{
public:
    AutoUpgradeTask(IAutoUpgradeHandler* pAutoUpgradeHandler);
    
    void onTimerFired(csf::TimerHelper *timer);
    
private:
    void ScanAndDownload();
    
    IAutoUpgradeHandler* m_pAutoUpgradeHandler;
};

class UnzipUtils
{
public:
    bool UnZipWithoutPassword(std::string zipPath, std::string extractFolderPath);
    bool UnZipWithPassword(std::string zipPath, std::string extractFolderPath, std::string password);
    
private:
    void change_file_date(const char * filename, uLong dosdate, tm_unz tmu_date);
};

class FileCheckerUtils
{
public:
    static std::string calc_file_sha256(const std::string& filePath);
    
    static bool checkSignature(const std::string& filePath);
    
    static bool checkSignatureForFolderFiles(const std::string& folder);
};

#endif /* defined(__AriesX__SDKAutoUpgrade__) */
